
Network Time Protocol (NTP) is a fundamental networking protocol used to synchronize the clocks of various devices across a network to an authoritative time source. This ensures consistent time settings, which is critical for many network operations.

### Network Time Protocol (NTP) Overview

- **Purpose**: NTP aims to maintain accurate time synchronization across a network, typically within milliseconds, by receiving updates from an authoritative time source.
- **Mechanism**:
    - NTP operates over User Datagram Protocol (UDP), utilizing port 123 for both source and destination.
    - It is highly efficient, often requiring no more than one packet per minute to synchronize two devices to within a millisecond.
- **Time Sources**:
    - Network administrators can implement private primary clocks synchronized to a Coordinated Universal Time (UTC)-based satellite or radio for secure clocking.
    - Public internet clock sources (e.g., `https://www.ntp.org`) are available but are considered less secure.

### NTP Stratum

- **Concept**: Stratum defines the hierarchical distance of an NTP device from an authoritative time source (stratum 0).
- **Stratum Levels**:
    - **Stratum 0**: These are highly precise reference clocks, such as atomic clocks or GPS receivers, that generate an accurate pulse per second signal. They cannot directly distribute time over a network.
    - **Stratum 1**: Time servers directly connected to a stratum 0 device. They act as primary time servers.
    - **Stratum 2**: Time servers that receive their time from stratum 1 servers.
    - The hierarchy continues, with a device synchronized to a stratum 'n' server running at stratum 'n + 1'.
- **Selection Process**: A device running NTP automatically selects the time source with the lowest stratum number it is configured to communicate with, effectively building a self-organizing tree.
- **Accuracy**: While higher stratum numbers indicate greater distance from the primary source and potentially less accuracy, public internet devices are typically within milliseconds of the source clock and remain accurate for most computational purposes.

### Importance and Use Cases of NTP

Accurate and synchronized time is crucial for various network operations:

- **Logging**: Ensures accurate timestamps for logs across different devices, essential for analyzing past events and troubleshooting.
- **Digital Certificate Validation**: Certificates are valid only if the current time falls within their specified time interval.
- **Single Sign-On (SSO) Authentication**: Required for security devices supporting SSO authentication against systems like Microsoft Active Directory.
- **Software-Defined Storage Stability**: Hyperconverged storage products require a stable and continuous NTP source for clock synchronization between components; functions like snapshots can fail if time differs.

### NTP Time Sources

NTP can obtain the correct time from various internal or external sources:

- Local primary clock
- Primary clock on the internet
- Global Positioning System (GPS) or atomic clock (stratum 0)
    - _Note_: A primary clock maintains accurate time from a hardware source, such as GPS, GLONASS, Galileo, or atomic clocks.

### NTP Synchronization Avoidance

NTP employs mechanisms to prevent synchronization with potentially ambiguous time sources:

- It never synchronizes to a device that is not synchronized itself.
- It compares time reported by multiple devices and avoids synchronizing to a device whose time is significantly different, even if its stratum is lower.

### Typical Enterprise NTP Architecture

- **Design Principle**: All devices should synchronize time to a single central point.
- **Common Designs**:
    - Designate a pair of internal devices (e.g., network core devices or redundantly deployed Windows Server Domain Controllers) to synchronize with public NTP servers.
    - Alternatively, deploy a local NTP server with GPS (stratum 1).
- **Stratum Levels in Enterprise**: Public/local GPS servers are typically stratum 1, making your designated internal devices stratum 2, and other devices synchronizing to them become stratum 3.
- **Security**:
    - Use trusted NTP servers.
    - Establish secure connections with NTP servers using key numbers and values.
- **Private/Secure Deployment**: For complete privacy and security, deploy a dedicated stratum 1 NTP server with built-in GPS, eliminating the need for internet access.
- **Device Responsibility**: The choice of stratum 2 devices (e.g., Microsoft domain controllers vs. core switches) depends on organizational responsibility and network design, especially for critical infrastructure like data centers.

### Configuring NTP on Cisco Devices

- **General Steps**:
    1. Configure the time zone.
    2. Configure the NTP server.
    3. Optionally, configure NTP authentication.
- **Recommendation**: Cisco recommends using NTP over manual time setting.
- **Cisco Secure Firewall Management Center (FMC)**:
    - Can serve as an NTP server for Cisco Secure Firewall Threat Defense devices if direct network NTP server access is unavailable.
    - However, using FMC as an NTP server is generally not recommended.
    - Disabling NTP on FMC after it served as an NTP server requires updating and redeploying platform settings for managed devices to find a new source.
- **Cisco 4100/9300 Series Security Appliances**: NTP is configured via the Cisco Secure Firewall Chassis Manager, not FMC.
- **Default NTP Servers**:
    - Cisco Secure Web Appliance: `time.sco.cisco.com`
    - Cisco Secure Email Gateway: `time.ironport.com`

### NTP Authentication

- **Risks**: Public NTP servers can be targets for exploitation, where attackers might impersonate legitimate servers.
- **Purpose**: NTP authentication prevents such attacks by verifying the authenticity of time sources.
- **Mechanism**:
    - NTP uses encoded keys to verify timestamps provided by NTP servers.
    - The device decrypts the received password and matches it with a pre-agreed key.
    - Upon successful authentication, NTP-related actions are authorized.
- **Support**: Not all devices support NTP authentication; examples that do include Cisco Secure Firewall ASA and Cisco IOS XE devices.
- **NTPv4 Symmetric Key Authentication**:
    - Provides a strong cryptographic authentication mechanism.
    - Keys are manually distributed across NTP devices.
    - Supports both IPv6 named and IPv4 numbered access lists.
- **FIPS-Approved Algorithms for Authentication**:
    - **Cipher-Based Message Authentication Code (CMAC)**: Triple Data Encryption Standard (3DES), Advanced Encryption Standard (AES).
    - **Hash Message Authentication Code (HMAC)**: Secure Hash Algorithm (SHA-1), SHA-224, SHA-256, SHA-384, SHA-512, SHA-512/224, and SHA-512/256.

### Use Case: Configure NTP on Cisco IOS XE Device

To configure NTP on a Cisco IOS XE router or switch:

- **Configuration Tasks**:
    - `clock timezone CET 1`
    - `clock summer-time CEST recurring last Sun Mar 2:00 last Sun Oct 3:00`
    - `ntp server 172.16.200.123`
    - `ntp authenticate`
    - `ntp authentication-key 1 md5 cisco`
    - `ntp server 172.16.200.123 key 1`
    - `ntp trusted-key 1`
- **Verification Commands**:
    - `show ntp status`
    - `show ntp associations [detail]`

### Use Case: Configure NTP on Cisco Secure Email Gateway

- **NTP Server Configuration**:
    - Navigate to `System Administration > Time Settings`.
    - Click `Edit Settings`.
    - Enter the fully qualified hostname or IP address of the NTP server (add rows as needed).
    - Submit and commit changes.
    - Optionally, choose the routing table (management or data) for NTP queries.
- **Recommendation**: Cisco recommends setting the Cisco Secure Email Gateway to track time by querying an NTP server rather than manual setting, especially for integrated devices.
- **Timezone Configuration**:
    - Navigate to `System Administration > Time Zone`.
    - Click `Edit Settings`.
    - Choose your region, country, and time zone or GMT offset.
    - Submit and commit changes.

### Use Case: Configure NTP on Cisco Secure Firewall ASA and Cisco Secure Firewall Threat Defense

- **Cisco Secure Firewall ASA**: Supports authenticated NTP configuration.
- **Cisco Secure Firewall Threat Defense**: Does not support NTP authentication.
- **Configuration Approach**: Configure ASA with authentication and Threat Defense without. An Internet-Router can be preconfigured as an NTP server for these setups.